jQuery(document).ready(function($) {
    if ($(".datepicker").length != 0) {

        var date = new Date();
        date.setDate(date.getDate() - 1);

        $(".datepicker").pickadate({
            firstDay: 1,
            format: "dd/mm/yyyy",
            disable: [{
                from: [2000, 1, 1],
                to: date
            }],
        });
    }

    if ($(".timepicker").length != 0) {
        function roundTimeHalfHour(time) {
            if (time == null) {
                var d = new Date();
                var time = d.getTime();
            }

            var timeToReturn = new Date(time);

            timeToReturn.setSeconds(Math.ceil(timeToReturn.getSeconds() / 60) * 60);
            timeToReturn.setMinutes(Math.ceil(timeToReturn.getMinutes() / 30) * 30);

            return timeToReturn;
        }

        $('.timepicker').timepicker({
            timeFormat: 'HH:mm',
            interval: 15,
            startTime: roundTimeHalfHour(),
            startMinutes: 0,
            dropdown: true,
            dynamic: true,
            scrollbar: false
        });
    }

    if ($("#pick-up-location").length != 0 || $("#drop-off-location").length != 0) {
        var placeSearch, autocomplete, autocomplete2, to;
        var componentForm = {
            street_number: 'short_name',
            route: 'long_name',
            locality: 'long_name',
            administrative_area_level_1: 'short_name',
            country: 'long_name',
            postal_code: 'short_name'
        };

        function fillInAddress(to) {
            // Get the place details from the autocomplete object.
            if (to == 'pick-up') {
                var place = autocomplete.getPlace();
            } else if (to == 'drop-off') {
                var place = autocomplete2.getPlace();
            }
            // Get each component of the address from the place details
            // and fill the corresponding field on the form.

            var possible_postal_code = place.address_components[place.address_components.length - 1].short_name;
            var numbers_only_ppc = possible_postal_code.replace(/\D/g, "");;

            // Check if it is postal code
            if (numbers_only_ppc >= 10000 && numbers_only_ppc <= 100001) {

                if (to == 'pick-up') {
                    $("#pick-up-post-code").val(numbers_only_ppc);
                } else if (to == 'drop-off') {
                    $("#drop-off-post-code").val(numbers_only_ppc);
                }

            }
        }

        function initAutocomplete() {
            var options = {
                types: ['geocode'],
                componentRestrictions: {
                    country: ['GR']
                }
            }
            autocomplete = new google.maps.places.Autocomplete(
                /** @type {!HTMLInputElement} */
                (document.getElementById('pick-up-location')),
                options);
            autocomplete.addListener('place_changed', function() {
                fillInAddress('pick-up');
            });

            autocomplete2 = new google.maps.places.Autocomplete(
                /** @type {!HTMLInputElement} */
                (document.getElementById('drop-off-location')),
                options);
            autocomplete2.addListener('place_changed', function() {
                fillInAddress('drop-off');
            });
        }
        initAutocomplete();

        // Disable enter for submiting form on locations
        var input = document.getElementById('pick-up-location');
        google.maps.event.addDomListener(input, 'keydown', function(event) {
            if (event.keyCode === 13) {
                event.preventDefault();
            }
        });

        var input = document.getElementById('drop-off-location');
        google.maps.event.addDomListener(input, 'keydown', function(event) {
            if (event.keyCode === 13) {
                event.preventDefault();
            }
        });
    }


    if ($("#main-search-form").length != 0) {

        // Pickup address selected
        $("#pick-up-select").on('change', function() {
            if (this.value == 'other' || this.value == 'other-1' || this.value == 'other-2') {
                if (this.value == 'other') {
                    $("#pick-up-location").val("Leof.Alexandras 10, Athina");
                    $('#pick-up-post-code').val('10682');
                }/* else if (this.value == 'other-1') {
                    $("#pick-up-location").val("Mitropoleos 15, Athina");
                    $('#pick-up-post-code').val('10557');
                } else if (this.value == 'other-2') {
                    $("#pick-up-location").val("18-20 Νικοδήμου Street");
                    $('#pick-up-post-code').val('10557');
                }*/
                var drop_off_val = $("#drop-off-select").val();
                if (drop_off_val == 'other' || drop_off_val == 'other-1' || drop_off_val == 'other-2') {
                    $("#drop-off-select").val('airport');
                    $("#drop-off-select option[value*='other']").prop('disabled', true);
                    $("#drop-off-select option").not("[value*='other']").prop('disabled', false);
                }

            } else {
                $("#drop-off-select").val('other');
                $("#drop-off-select option[value*='other']").prop('disabled', false);
                $("#drop-off-select option").not("[value*='other']").prop('disabled', true);
            }
        });

        // Pickup address selected
        $("#drop-off-select").on('change', function() {
            if (this.value == 'other' || this.value == 'other-1' || this.value == 'other-2') {

                if (this.value == 'other') {
                    $("#drop-off-location").val("Leof.Alexandras 10, Athina");
                    $('#drop-off-post-code').val('10682');
                }/* else if (this.value == 'other-1') {
                    $("#drop-off-location").val("Mitropoleos 15, Athina");
                    $('#drop-off-post-code').val('10557');
                } else if (this.value == 'other-2') {
                    $("#drop-off-location").val("18-20 Νικοδήμου Street");
                    $('#drop-off-post-code').val('10557');
                }*/
                //$("#pick-up-select option[value*='other']").prop('disabled', true);

                $("#pick-up-select").val('airport');
            } else {
                $("#pick-up-select").val('other');
            }
        });

        // console.log($("#pick-up-select").val());
        // console.log($("#drop-off-select").val());
        if ($("#drop-off-select").val() == 'airport' && $("#drop-off-select").val() == "airport") {
            $("#drop-off-select").val('other');
            $("#drop-off-location").val("Leof.Alexandras 10, Athina");
            $('#drop-off-post-code').val('10682');
        }
        // Return journey toggle
        $("#return-journey").change(function() {
            if (this.checked) {
                $(".return-wrapper").slideDown("slow");
            } else {
                $(".return-wrapper").slideUp("slow");
            }
        });

        $("#main-search-form").submit(function(event) {

            // Check if both pickup and drop off are the same.
            if ($("#pick-up-select option:selected").val() == $("#drop-off-select option:selected").val()) {
                $('#drop-off-select').addClass('form-has-error');
            } else {
                $('#drop-off-select').removeClass('form-has-error');
            }

            //Check if other address not typed
            if ($("#pick-up-select option:selected").val() == 'other') {
                if ($('#pick-up-location').val() == "") {
                    $('#pick-up-location').addClass('form-has-error');
                } else {
                    $('#pick-up-location').removeClass('form-has-error');
                }
            }

            //Check if other address not typed
            if ($("#drop-off-select option:selected").val() == 'other') {
                if ($('#drop-off-location').val() == "") {
                    $('#drop-off-location').addClass('form-has-error');
                } else {
                    $('#drop-off-location').removeClass('form-has-error');
                }
            }

            // Check if pickup date is empty
            if ($('#pick-up-date').val() == "") {
                $('#pick-up-date').addClass('form-has-error');
            } else {
                $('#pick-up-date').removeClass('form-has-error');
            }

            // Check if pickup time is empty
            if ($('#pick-up-time').val() == "") {
                $('#pick-up-time').addClass('form-has-error');
            } else {
                $('#pick-up-time').removeClass('form-has-error');
            }

            if ($('#return-journey:checkbox:checked').length > 0) {
                // Check if return date is empty
                if ($('#return-date').val() == "") {
                    $('#return-date').addClass('form-has-error');
                } else {
                    $('#return-date').removeClass('form-has-error');
                }

                // Check if return time is empty
                if ($('#return-time').val() == "") {
                    $('#return-time').addClass('form-has-error');
                } else {
                    $('#return-time').removeClass('form-has-error');
                }
            }

            if ($(".form-has-error").length != 0) {
                setTimeout(function() {
                    $('.form-has-error').removeClass('form-has-error');
                }, 2000);
                event.preventDefault();
            }



        });
    }

  //Woo Checkout
    if ($("#arriving_on_ship").length != 0) {
        $("#arriving_on_ship").change(function() {
            if (this.checked) {
            	$('#ship_name_text').attr('value','');
            	setTimeout(function(){
	            	$('#by_air_name_text').attr('value', '0');
            	}, 1200);
                $("#ship_name_text_field").slideDown("slow");
                // Hide other option
                $('#arriving_by_air').prop('checked', false);
                $("#by_air_name_text_field").slideUp("slow");
            } else {
            	setTimeout(function(){
	            	$('#ship_name_text').attr('value', '0');
	            	$('#by_air_name_text').attr('value', '0');
            	}, 1200);
                $("#ship_name_text_field").slideUp("slow");
            }
        });
    }

    if ($("#arriving_by_air").length != 0) {
        $("#arriving_by_air").change(function() {
            if (this.checked) {
            	setTimeout(function(){
            		$('#ship_name_text').attr('value', '0');
            	}, 1200);
            	$('#by_air_name_text').attr('value', '');
                $("#by_air_name_text_field").slideDown("slow");
                //Hide other option
                $('#arriving_on_ship').prop('checked', false);
                $("#ship_name_text_field").slideUp("slow");
            } else {
            	setTimeout(function(){
	            	$('#ship_name_text').attr('value','0');
	            	$('#by_air_name_text').attr('value', '0');
            	}, 1200);
                $("#by_air_name_text_field").slideUp("slow");
            }
        });
    }

    if ($("#billing_phone").length != 0) {
        var input = document.querySelector("#billing_phone");

        var iti = window.intlTelInput(input, {
            initialCountry: 'gr',
            preferredCountries: ['gr', 'gb', 'de', 'fr', 'it', 'es'],
        });
        input.addEventListener("countrychange", function() {
            var countryData = iti.getSelectedCountryData();
            $('#billing_phone').val('+' + countryData.dialCode + "-");
        });


        if ($('#billing_phone').val()=="" || $('#billing_phone').val() == null) {
            $('#billing_phone').val('+30-');
        }
    }

    if ($("#extra-options-page").length != 0) {
        $("#baby-seats").change(function() {
            var seat_price = $("#baby-seat-price").val();
            var seat_number = $("#baby-seats").val();
            var current_price = $("#info_price").val();

            var total_cost = +(seat_price * seat_number) + +current_price;

            $("#big-price").html(total_cost);
            $("#price").val(total_cost);
        });

    }
}); // All End