<?php
/* Template Name: Extra Taxi Options  */

get_header();

$container   = get_theme_mod( 'understrap_container_type' );
remove_filter('the_content', 'wpautop');

// Get pricing per post_code per port/airport per car

if ($_GET){
	$data['taxi_id'] = sanitize_text_field($_GET['taxi_id']);
	$data['pick-up-select'] = sanitize_text_field($_GET['pick-up-select']);
	$data['pick-up-location'] = sanitize_text_field($_GET['pick-up-location']);
	$data['pick-up-post-code'] = sanitize_text_field($_GET['pick-up-post-code']);

	$data['drop-off-select'] = sanitize_text_field($_GET['drop-off-select']);
	$data['drop-off-location'] = sanitize_text_field($_GET['drop-off-location']);
	$data['drop-off-post-code'] = sanitize_text_field($_GET['drop-off-post-code']);
	$data['pick-up-date'] = sanitize_text_field($_GET['pick-up-date']);
	$data['pick-up-time'] = sanitize_text_field($_GET['pick-up-time']);
	$data['pick-up-price']= sanitize_text_field($_GET['pick_up_price']);
	$data['return-journey'] = ($_GET['return-journey']==1?true:false);
	$data['passengers'] = sanitize_text_field($_GET['passengers']);
	$data['return-date'] = sanitize_text_field($_GET['return-date']);
	$data['return-time'] = sanitize_text_field($_GET['return-time']);
	$data['return-price']= sanitize_text_field($_GET['return_price']);
	$data['price'] = sanitize_text_field($_GET['price']);
	$data['max_luggage'] = get_post_meta($data['taxi_id'], 'standard_bags', true);

}
?>

<div class="wrapper " id="page-wrapper">

	<div class="<?php echo esc_attr( $container ); ?>">
		<div id="extra-options-page">
			<div class="extra-options-wrapper">
				<?php the_content(); ?>
				<div class="extra-options-form-wrapper">
					<form method="get" action="<?php echo wc_get_cart_url();?>">
					  <div class="form-row">
					    <div class="form-group col-md-6">
					      <label for="luggages"><?php echo __('Standard Size Luggage', 'taxiplon'); ?>:</label>
								<select class="form-control" id="luggages" name="luggages" class="form-control">
									<?php
									if (!$data['max_luggage']){$data['max_luggage'] = 0;}
										for($i = 0; $i <= $data['max_luggage']; ++$i) {
										    echo "<option>".$i."</option>";
										} ?>
								</select>
					    </div>
							<div class="form-group col-md-6">
					      <label for="baby-seats"><?php echo __('Baby Seats', 'taxiplon'); ?>:</label>
								<select class="form-control" id="baby-seats" name="baby-seats" class="form-control">
									<option value="0">0</option>
									<option value="1">1 <?php if ($data['return-journey']) { ?>(+10€)<?php } else { ?>(+5€)<?php } ?></option>
									<option value="2">2 <?php if ($data['return-journey']) { ?>(+20€)<?php } else { ?>(+10€)<?php } ?></option>
								</select>
					    </div>
							<input type="hidden" id="baby-seat-price" name="baby-seat-price" value="<?php if ($data['return-journey']) { echo 10; } else { echo 5; } ?>">
							<input type="hidden" id="info_price" name="info_price" value="<?php echo $data['price']; ?>">
							<input type="hidden" id="add-to-cart" name="add-to-cart" value="<?php echo $data['taxi_id']; ?>">
							<input type="hidden" id="price" name="price" value="<?php echo $data['price']; ?>">
							<?php
								$add_to_cart_extra = "";
								$do_not_add = array('taxi_id',  'max_luggage', 'price');
								// Create link from $data array;
								foreach ($data as $key => $value) {
									if (!in_array($key, $do_not_add)){
										$add_to_cart_extra .= "&amp;".$key."=".$value;
										?><input type="hidden" id="<?php echo $key;?>" name="<?php echo $key;?>" value="<?php echo $value;?>"><?php
									}
								}
							?>

							<div class="form-group col-md-6">
								<div class="total_price">
									<?php echo __('Total cost', 'taxiplon'); ?>: <span id="big-price"><?php echo $data['price'];?></span> <span>€</span>
								</div>
							</div>
							<div class="col-md-6">
								<div class="order-button">
									<button type="submit"  class="btn btn-taxiplon btn-lg btn-block"><?php echo __('Book Now', 'taxiplon'); ?></button>
								</div>
							</div>

					</form>

				</div>
			</div>


		</div>

	</div><!-- Container end -->

</div><!-- Wrapper end -->

<?php get_footer(); ?>
